/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.valhelsia.valhelsia_core.capability.counter.CounterProvider;
import net.valhelsia.valhelsia_core.capability.counter.SimpleCounter;

public class UpdateCounterPacket {
    private final SimpleCounter timer;

    public UpdateCounterPacket(SimpleCounter timer) {
        this.timer = timer;
    }

    public static void encode(UpdateCounterPacket packet, PacketBuffer buffer) {
        CompoundNBT compound = packet.timer.save(new CompoundNBT());
        compound.func_74778_a("name", packet.timer.getName().toString());
        buffer.func_150786_a(compound);
    }

    public static UpdateCounterPacket decode(PacketBuffer buffer) {
        CompoundNBT compound = buffer.func_150793_b();
        SimpleCounter timer = new SimpleCounter(new ResourceLocation(Objects.requireNonNull(compound).func_74779_i("name")));
        timer.load(compound);
        return new UpdateCounterPacket(timer);
    }

    public static void consume(UpdateCounterPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                player.getCapability(CounterProvider.CAPABILITY).ifPresent(counterCapability -> counterCapability.getCounter(packet.timer.getName()).load(packet.timer.save(new CompoundNBT())));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

